package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateContactResponse(contactArn: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.CreateContactResponse = {
    import CreateContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.CreateContactResponse
      .builder()
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.CreateContactResponse.ReadOnly =
    zio.aws.ssmcontacts.model.CreateContactResponse.wrap(buildAwsValue())
}
object CreateContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.CreateContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.CreateContactResponse =
      zio.aws.ssmcontacts.model.CreateContactResponse(contactArn)
    def contactArn: SsmContactsArn
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.CreateContactResponse
  ) extends zio.aws.ssmcontacts.model.CreateContactResponse.ReadOnly {
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.CreateContactResponse
  ): zio.aws.ssmcontacts.model.CreateContactResponse.ReadOnly = new Wrapper(
    impl
  )
}
