package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeactivateContactChannelRequest(
    contactChannelId: SsmContactsArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.DeactivateContactChannelRequest = {
    import DeactivateContactChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.DeactivateContactChannelRequest
      .builder()
      .contactChannelId(
        SsmContactsArn.unwrap(contactChannelId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.DeactivateContactChannelRequest.ReadOnly =
    zio.aws.ssmcontacts.model.DeactivateContactChannelRequest
      .wrap(buildAwsValue())
}
object DeactivateContactChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.DeactivateContactChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.DeactivateContactChannelRequest =
      zio.aws.ssmcontacts.model
        .DeactivateContactChannelRequest(contactChannelId)
    def contactChannelId: SsmContactsArn
    def getContactChannelId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DeactivateContactChannelRequest
  ) extends zio.aws.ssmcontacts.model.DeactivateContactChannelRequest.ReadOnly {
    override val contactChannelId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DeactivateContactChannelRequest
  ): zio.aws.ssmcontacts.model.DeactivateContactChannelRequest.ReadOnly =
    new Wrapper(impl)
}
