package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteContactChannelRequest(contactChannelId: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.DeleteContactChannelRequest = {
    import DeleteContactChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.DeleteContactChannelRequest
      .builder()
      .contactChannelId(
        SsmContactsArn.unwrap(contactChannelId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.DeleteContactChannelRequest.ReadOnly =
    zio.aws.ssmcontacts.model.DeleteContactChannelRequest.wrap(buildAwsValue())
}
object DeleteContactChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.DeleteContactChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.DeleteContactChannelRequest =
      zio.aws.ssmcontacts.model.DeleteContactChannelRequest(contactChannelId)
    def contactChannelId: SsmContactsArn
    def getContactChannelId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DeleteContactChannelRequest
  ) extends zio.aws.ssmcontacts.model.DeleteContactChannelRequest.ReadOnly {
    override val contactChannelId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DeleteContactChannelRequest
  ): zio.aws.ssmcontacts.model.DeleteContactChannelRequest.ReadOnly =
    new Wrapper(impl)
}
