package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteContactRequest(contactId: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.DeleteContactRequest = {
    import DeleteContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.DeleteContactRequest
      .builder()
      .contactId(SsmContactsArn.unwrap(contactId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.DeleteContactRequest.ReadOnly =
    zio.aws.ssmcontacts.model.DeleteContactRequest.wrap(buildAwsValue())
}
object DeleteContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.DeleteContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.DeleteContactRequest =
      zio.aws.ssmcontacts.model.DeleteContactRequest(contactId)
    def contactId: SsmContactsArn
    def getContactId: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DeleteContactRequest
  ) extends zio.aws.ssmcontacts.model.DeleteContactRequest.ReadOnly {
    override val contactId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DeleteContactRequest
  ): zio.aws.ssmcontacts.model.DeleteContactRequest.ReadOnly = new Wrapper(impl)
}
