package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeEngagementRequest(engagementId: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementRequest = {
    import DescribeEngagementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementRequest
      .builder()
      .engagementId(SsmContactsArn.unwrap(engagementId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.DescribeEngagementRequest.ReadOnly =
    zio.aws.ssmcontacts.model.DescribeEngagementRequest.wrap(buildAwsValue())
}
object DescribeEngagementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.DescribeEngagementRequest =
      zio.aws.ssmcontacts.model.DescribeEngagementRequest(engagementId)
    def engagementId: SsmContactsArn
    def getEngagementId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(engagementId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementRequest
  ) extends zio.aws.ssmcontacts.model.DescribeEngagementRequest.ReadOnly {
    override val engagementId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.engagementId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementRequest
  ): zio.aws.ssmcontacts.model.DescribeEngagementRequest.ReadOnly = new Wrapper(
    impl
  )
}
