package zio.aws.ssmcontacts.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  PublicSubject,
  SsmContactsArn,
  DateTime,
  PublicContent,
  Subject,
  Sender,
  IncidentId,
  Content
}
import scala.jdk.CollectionConverters._
final case class DescribeEngagementResponse(
    contactArn: SsmContactsArn,
    engagementArn: SsmContactsArn,
    sender: Sender,
    subject: Subject,
    content: Content,
    publicSubject: Optional[PublicSubject] = Optional.Absent,
    publicContent: Optional[PublicContent] = Optional.Absent,
    incidentId: Optional[IncidentId] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    stopTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementResponse = {
    import DescribeEngagementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementResponse
      .builder()
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .engagementArn(SsmContactsArn.unwrap(engagementArn): java.lang.String)
      .sender(Sender.unwrap(sender): java.lang.String)
      .subject(Subject.unwrap(subject): java.lang.String)
      .content(Content.unwrap(content): java.lang.String)
      .optionallyWith(
        publicSubject.map(value =>
          PublicSubject.unwrap(value): java.lang.String
        )
      )(_.publicSubject)
      .optionallyWith(
        publicContent.map(value =>
          PublicContent.unwrap(value): java.lang.String
        )
      )(_.publicContent)
      .optionallyWith(
        incidentId.map(value => IncidentId.unwrap(value): java.lang.String)
      )(_.incidentId)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(stopTime.map(value => DateTime.unwrap(value): Instant))(
        _.stopTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.DescribeEngagementResponse.ReadOnly =
    zio.aws.ssmcontacts.model.DescribeEngagementResponse.wrap(buildAwsValue())
}
object DescribeEngagementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.DescribeEngagementResponse =
      zio.aws.ssmcontacts.model.DescribeEngagementResponse(
        contactArn,
        engagementArn,
        sender,
        subject,
        content,
        publicSubject.map(value => value),
        publicContent.map(value => value),
        incidentId.map(value => value),
        startTime.map(value => value),
        stopTime.map(value => value)
      )
    def contactArn: SsmContactsArn
    def engagementArn: SsmContactsArn
    def sender: Sender
    def subject: Subject
    def content: Content
    def publicSubject: Optional[PublicSubject]
    def publicContent: Optional[PublicContent]
    def incidentId: Optional[IncidentId]
    def startTime: Optional[DateTime]
    def stopTime: Optional[DateTime]
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
    def getEngagementArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(engagementArn)
    def getSender: ZIO[Any, Nothing, Sender] = ZIO.succeed(sender)
    def getSubject: ZIO[Any, Nothing, Subject] = ZIO.succeed(subject)
    def getContent: ZIO[Any, Nothing, Content] = ZIO.succeed(content)
    def getPublicSubject: ZIO[Any, AwsError, PublicSubject] =
      AwsError.unwrapOptionField("publicSubject", publicSubject)
    def getPublicContent: ZIO[Any, AwsError, PublicContent] =
      AwsError.unwrapOptionField("publicContent", publicContent)
    def getIncidentId: ZIO[Any, AwsError, IncidentId] =
      AwsError.unwrapOptionField("incidentId", incidentId)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStopTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stopTime", stopTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementResponse
  ) extends zio.aws.ssmcontacts.model.DescribeEngagementResponse.ReadOnly {
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
    override val engagementArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.engagementArn())
    override val sender: Sender =
      zio.aws.ssmcontacts.model.primitives.Sender(impl.sender())
    override val subject: Subject =
      zio.aws.ssmcontacts.model.primitives.Subject(impl.subject())
    override val content: Content =
      zio.aws.ssmcontacts.model.primitives.Content(impl.content())
    override val publicSubject: Optional[PublicSubject] = zio.aws.core.internal
      .optionalFromNullable(impl.publicSubject())
      .map(value => zio.aws.ssmcontacts.model.primitives.PublicSubject(value))
    override val publicContent: Optional[PublicContent] = zio.aws.core.internal
      .optionalFromNullable(impl.publicContent())
      .map(value => zio.aws.ssmcontacts.model.primitives.PublicContent(value))
    override val incidentId: Optional[IncidentId] = zio.aws.core.internal
      .optionalFromNullable(impl.incidentId())
      .map(value => zio.aws.ssmcontacts.model.primitives.IncidentId(value))
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
    override val stopTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DescribeEngagementResponse
  ): zio.aws.ssmcontacts.model.DescribeEngagementResponse.ReadOnly =
    new Wrapper(impl)
}
