package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribePageRequest(pageId: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.DescribePageRequest = {
    import DescribePageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.DescribePageRequest
      .builder()
      .pageId(SsmContactsArn.unwrap(pageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.DescribePageRequest.ReadOnly =
    zio.aws.ssmcontacts.model.DescribePageRequest.wrap(buildAwsValue())
}
object DescribePageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.DescribePageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.DescribePageRequest =
      zio.aws.ssmcontacts.model.DescribePageRequest(pageId)
    def pageId: SsmContactsArn
    def getPageId: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(pageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DescribePageRequest
  ) extends zio.aws.ssmcontacts.model.DescribePageRequest.ReadOnly {
    override val pageId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.pageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DescribePageRequest
  ): zio.aws.ssmcontacts.model.DescribePageRequest.ReadOnly = new Wrapper(impl)
}
