package zio.aws.ssmcontacts.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  PublicSubject,
  SsmContactsArn,
  DateTime,
  PublicContent,
  Subject,
  Sender,
  IncidentId,
  Content
}
import scala.jdk.CollectionConverters._
final case class DescribePageResponse(
    pageArn: SsmContactsArn,
    engagementArn: SsmContactsArn,
    contactArn: SsmContactsArn,
    sender: Sender,
    subject: Subject,
    content: Content,
    publicSubject: Optional[PublicSubject] = Optional.Absent,
    publicContent: Optional[PublicContent] = Optional.Absent,
    incidentId: Optional[IncidentId] = Optional.Absent,
    sentTime: Optional[DateTime] = Optional.Absent,
    readTime: Optional[DateTime] = Optional.Absent,
    deliveryTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.DescribePageResponse = {
    import DescribePageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.DescribePageResponse
      .builder()
      .pageArn(SsmContactsArn.unwrap(pageArn): java.lang.String)
      .engagementArn(SsmContactsArn.unwrap(engagementArn): java.lang.String)
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .sender(Sender.unwrap(sender): java.lang.String)
      .subject(Subject.unwrap(subject): java.lang.String)
      .content(Content.unwrap(content): java.lang.String)
      .optionallyWith(
        publicSubject.map(value =>
          PublicSubject.unwrap(value): java.lang.String
        )
      )(_.publicSubject)
      .optionallyWith(
        publicContent.map(value =>
          PublicContent.unwrap(value): java.lang.String
        )
      )(_.publicContent)
      .optionallyWith(
        incidentId.map(value => IncidentId.unwrap(value): java.lang.String)
      )(_.incidentId)
      .optionallyWith(sentTime.map(value => DateTime.unwrap(value): Instant))(
        _.sentTime
      )
      .optionallyWith(readTime.map(value => DateTime.unwrap(value): Instant))(
        _.readTime
      )
      .optionallyWith(
        deliveryTime.map(value => DateTime.unwrap(value): Instant)
      )(_.deliveryTime)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.DescribePageResponse.ReadOnly =
    zio.aws.ssmcontacts.model.DescribePageResponse.wrap(buildAwsValue())
}
object DescribePageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.DescribePageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.DescribePageResponse =
      zio.aws.ssmcontacts.model.DescribePageResponse(
        pageArn,
        engagementArn,
        contactArn,
        sender,
        subject,
        content,
        publicSubject.map(value => value),
        publicContent.map(value => value),
        incidentId.map(value => value),
        sentTime.map(value => value),
        readTime.map(value => value),
        deliveryTime.map(value => value)
      )
    def pageArn: SsmContactsArn
    def engagementArn: SsmContactsArn
    def contactArn: SsmContactsArn
    def sender: Sender
    def subject: Subject
    def content: Content
    def publicSubject: Optional[PublicSubject]
    def publicContent: Optional[PublicContent]
    def incidentId: Optional[IncidentId]
    def sentTime: Optional[DateTime]
    def readTime: Optional[DateTime]
    def deliveryTime: Optional[DateTime]
    def getPageArn: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(pageArn)
    def getEngagementArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(engagementArn)
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
    def getSender: ZIO[Any, Nothing, Sender] = ZIO.succeed(sender)
    def getSubject: ZIO[Any, Nothing, Subject] = ZIO.succeed(subject)
    def getContent: ZIO[Any, Nothing, Content] = ZIO.succeed(content)
    def getPublicSubject: ZIO[Any, AwsError, PublicSubject] =
      AwsError.unwrapOptionField("publicSubject", publicSubject)
    def getPublicContent: ZIO[Any, AwsError, PublicContent] =
      AwsError.unwrapOptionField("publicContent", publicContent)
    def getIncidentId: ZIO[Any, AwsError, IncidentId] =
      AwsError.unwrapOptionField("incidentId", incidentId)
    def getSentTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("sentTime", sentTime)
    def getReadTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("readTime", readTime)
    def getDeliveryTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("deliveryTime", deliveryTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DescribePageResponse
  ) extends zio.aws.ssmcontacts.model.DescribePageResponse.ReadOnly {
    override val pageArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.pageArn())
    override val engagementArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.engagementArn())
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
    override val sender: Sender =
      zio.aws.ssmcontacts.model.primitives.Sender(impl.sender())
    override val subject: Subject =
      zio.aws.ssmcontacts.model.primitives.Subject(impl.subject())
    override val content: Content =
      zio.aws.ssmcontacts.model.primitives.Content(impl.content())
    override val publicSubject: Optional[PublicSubject] = zio.aws.core.internal
      .optionalFromNullable(impl.publicSubject())
      .map(value => zio.aws.ssmcontacts.model.primitives.PublicSubject(value))
    override val publicContent: Optional[PublicContent] = zio.aws.core.internal
      .optionalFromNullable(impl.publicContent())
      .map(value => zio.aws.ssmcontacts.model.primitives.PublicContent(value))
    override val incidentId: Optional[IncidentId] = zio.aws.core.internal
      .optionalFromNullable(impl.incidentId())
      .map(value => zio.aws.ssmcontacts.model.primitives.IncidentId(value))
    override val sentTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.sentTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
    override val readTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.readTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
    override val deliveryTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.DescribePageResponse
  ): zio.aws.ssmcontacts.model.DescribePageResponse.ReadOnly = new Wrapper(impl)
}
