package zio.aws.ssmcontacts.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  DateTime,
  IncidentId,
  Sender,
  SsmContactsArn
}
import scala.jdk.CollectionConverters._
final case class Engagement(
    engagementArn: SsmContactsArn,
    contactArn: SsmContactsArn,
    sender: Sender,
    incidentId: Optional[IncidentId] = Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    stopTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.Engagement = {
    import Engagement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.Engagement
      .builder()
      .engagementArn(SsmContactsArn.unwrap(engagementArn): java.lang.String)
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .sender(Sender.unwrap(sender): java.lang.String)
      .optionallyWith(
        incidentId.map(value => IncidentId.unwrap(value): java.lang.String)
      )(_.incidentId)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(stopTime.map(value => DateTime.unwrap(value): Instant))(
        _.stopTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.Engagement.ReadOnly =
    zio.aws.ssmcontacts.model.Engagement.wrap(buildAwsValue())
}
object Engagement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.Engagement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.Engagement =
      zio.aws.ssmcontacts.model.Engagement(
        engagementArn,
        contactArn,
        sender,
        incidentId.map(value => value),
        startTime.map(value => value),
        stopTime.map(value => value)
      )
    def engagementArn: SsmContactsArn
    def contactArn: SsmContactsArn
    def sender: Sender
    def incidentId: Optional[IncidentId]
    def startTime: Optional[DateTime]
    def stopTime: Optional[DateTime]
    def getEngagementArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(engagementArn)
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
    def getSender: ZIO[Any, Nothing, Sender] = ZIO.succeed(sender)
    def getIncidentId: ZIO[Any, AwsError, IncidentId] =
      AwsError.unwrapOptionField("incidentId", incidentId)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStopTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("stopTime", stopTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Engagement
  ) extends zio.aws.ssmcontacts.model.Engagement.ReadOnly {
    override val engagementArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.engagementArn())
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
    override val sender: Sender =
      zio.aws.ssmcontacts.model.primitives.Sender(impl.sender())
    override val incidentId: Optional[IncidentId] = zio.aws.core.internal
      .optionalFromNullable(impl.incidentId())
      .map(value => zio.aws.ssmcontacts.model.primitives.IncidentId(value))
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
    override val stopTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.stopTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Engagement
  ): zio.aws.ssmcontacts.model.Engagement.ReadOnly = new Wrapper(impl)
}
