package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetContactChannelRequest(contactChannelId: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelRequest = {
    import GetContactChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelRequest
      .builder()
      .contactChannelId(
        SsmContactsArn.unwrap(contactChannelId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.GetContactChannelRequest.ReadOnly =
    zio.aws.ssmcontacts.model.GetContactChannelRequest.wrap(buildAwsValue())
}
object GetContactChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.GetContactChannelRequest =
      zio.aws.ssmcontacts.model.GetContactChannelRequest(contactChannelId)
    def contactChannelId: SsmContactsArn
    def getContactChannelId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelRequest
  ) extends zio.aws.ssmcontacts.model.GetContactChannelRequest.ReadOnly {
    override val contactChannelId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelRequest
  ): zio.aws.ssmcontacts.model.GetContactChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
