package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{ChannelName, SsmContactsArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContactChannelResponse(
    contactArn: SsmContactsArn,
    contactChannelArn: SsmContactsArn,
    name: ChannelName,
    `type`: zio.aws.ssmcontacts.model.ChannelType,
    deliveryAddress: zio.aws.ssmcontacts.model.ContactChannelAddress,
    activationStatus: Optional[zio.aws.ssmcontacts.model.ActivationStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelResponse = {
    import GetContactChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelResponse
      .builder()
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .contactChannelArn(
        SsmContactsArn.unwrap(contactChannelArn): java.lang.String
      )
      .name(ChannelName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .deliveryAddress(deliveryAddress.buildAwsValue())
      .optionallyWith(activationStatus.map(value => value.unwrap))(
        _.activationStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.GetContactChannelResponse.ReadOnly =
    zio.aws.ssmcontacts.model.GetContactChannelResponse.wrap(buildAwsValue())
}
object GetContactChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.GetContactChannelResponse =
      zio.aws.ssmcontacts.model.GetContactChannelResponse(
        contactArn,
        contactChannelArn,
        name,
        `type`,
        deliveryAddress.asEditable,
        activationStatus.map(value => value)
      )
    def contactArn: SsmContactsArn
    def contactChannelArn: SsmContactsArn
    def name: ChannelName
    def `type`: zio.aws.ssmcontacts.model.ChannelType
    def deliveryAddress
        : zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly
    def activationStatus: Optional[zio.aws.ssmcontacts.model.ActivationStatus]
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
    def getContactChannelArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelArn)
    def getName: ZIO[Any, Nothing, ChannelName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.ssmcontacts.model.ChannelType] =
      ZIO.succeed(`type`)
    def getDeliveryAddress: ZIO[
      Any,
      Nothing,
      zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly
    ] = ZIO.succeed(deliveryAddress)
    def getActivationStatus
        : ZIO[Any, AwsError, zio.aws.ssmcontacts.model.ActivationStatus] =
      AwsError.unwrapOptionField("activationStatus", activationStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelResponse
  ) extends zio.aws.ssmcontacts.model.GetContactChannelResponse.ReadOnly {
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
    override val contactChannelArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelArn())
    override val name: ChannelName =
      zio.aws.ssmcontacts.model.primitives.ChannelName(impl.name())
    override val `type`: zio.aws.ssmcontacts.model.ChannelType =
      zio.aws.ssmcontacts.model.ChannelType.wrap(impl.`type`())
    override val deliveryAddress
        : zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly =
      zio.aws.ssmcontacts.model.ContactChannelAddress
        .wrap(impl.deliveryAddress())
    override val activationStatus
        : Optional[zio.aws.ssmcontacts.model.ActivationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activationStatus())
        .map(value => zio.aws.ssmcontacts.model.ActivationStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactChannelResponse
  ): zio.aws.ssmcontacts.model.GetContactChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
