package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetContactPolicyRequest(contactArn: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyRequest = {
    import GetContactPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyRequest
      .builder()
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.GetContactPolicyRequest.ReadOnly =
    zio.aws.ssmcontacts.model.GetContactPolicyRequest.wrap(buildAwsValue())
}
object GetContactPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.GetContactPolicyRequest =
      zio.aws.ssmcontacts.model.GetContactPolicyRequest(contactArn)
    def contactArn: SsmContactsArn
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyRequest
  ) extends zio.aws.ssmcontacts.model.GetContactPolicyRequest.ReadOnly {
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyRequest
  ): zio.aws.ssmcontacts.model.GetContactPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
