package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{Policy, SsmContactsArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContactPolicyResponse(
    contactArn: Optional[SsmContactsArn] = Optional.Absent,
    policy: Optional[Policy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyResponse = {
    import GetContactPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyResponse
      .builder()
      .optionallyWith(
        contactArn.map(value => SsmContactsArn.unwrap(value): java.lang.String)
      )(_.contactArn)
      .optionallyWith(
        policy.map(value => Policy.unwrap(value): java.lang.String)
      )(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.GetContactPolicyResponse.ReadOnly =
    zio.aws.ssmcontacts.model.GetContactPolicyResponse.wrap(buildAwsValue())
}
object GetContactPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.GetContactPolicyResponse =
      zio.aws.ssmcontacts.model.GetContactPolicyResponse(
        contactArn.map(value => value),
        policy.map(value => value)
      )
    def contactArn: Optional[SsmContactsArn]
    def policy: Optional[Policy]
    def getContactArn: ZIO[Any, AwsError, SsmContactsArn] =
      AwsError.unwrapOptionField("contactArn", contactArn)
    def getPolicy: ZIO[Any, AwsError, Policy] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyResponse
  ) extends zio.aws.ssmcontacts.model.GetContactPolicyResponse.ReadOnly {
    override val contactArn: Optional[SsmContactsArn] = zio.aws.core.internal
      .optionalFromNullable(impl.contactArn())
      .map(value => zio.aws.ssmcontacts.model.primitives.SsmContactsArn(value))
    override val policy: Optional[Policy] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => zio.aws.ssmcontacts.model.primitives.Policy(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactPolicyResponse
  ): zio.aws.ssmcontacts.model.GetContactPolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
