package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetContactRequest(contactId: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.GetContactRequest = {
    import GetContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.GetContactRequest
      .builder()
      .contactId(SsmContactsArn.unwrap(contactId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.GetContactRequest.ReadOnly =
    zio.aws.ssmcontacts.model.GetContactRequest.wrap(buildAwsValue())
}
object GetContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.GetContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.GetContactRequest =
      zio.aws.ssmcontacts.model.GetContactRequest(contactId)
    def contactId: SsmContactsArn
    def getContactId: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(contactId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactRequest
  ) extends zio.aws.ssmcontacts.model.GetContactRequest.ReadOnly {
    override val contactId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactRequest
  ): zio.aws.ssmcontacts.model.GetContactRequest.ReadOnly = new Wrapper(impl)
}
