package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{
  ContactName,
  ContactAlias,
  SsmContactsArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetContactResponse(
    contactArn: SsmContactsArn,
    alias: ContactAlias,
    displayName: Optional[ContactName] = Optional.Absent,
    `type`: zio.aws.ssmcontacts.model.ContactType,
    plan: zio.aws.ssmcontacts.model.Plan
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.GetContactResponse = {
    import GetContactResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.GetContactResponse
      .builder()
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .alias(ContactAlias.unwrap(alias): java.lang.String)
      .optionallyWith(
        displayName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.displayName)
      .`type`(`type`.unwrap)
      .plan(plan.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.GetContactResponse.ReadOnly =
    zio.aws.ssmcontacts.model.GetContactResponse.wrap(buildAwsValue())
}
object GetContactResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.GetContactResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.GetContactResponse =
      zio.aws.ssmcontacts.model.GetContactResponse(
        contactArn,
        alias,
        displayName.map(value => value),
        `type`,
        plan.asEditable
      )
    def contactArn: SsmContactsArn
    def alias: ContactAlias
    def displayName: Optional[ContactName]
    def `type`: zio.aws.ssmcontacts.model.ContactType
    def plan: zio.aws.ssmcontacts.model.Plan.ReadOnly
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
    def getAlias: ZIO[Any, Nothing, ContactAlias] = ZIO.succeed(alias)
    def getDisplayName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getType: ZIO[Any, Nothing, zio.aws.ssmcontacts.model.ContactType] =
      ZIO.succeed(`type`)
    def getPlan: ZIO[Any, Nothing, zio.aws.ssmcontacts.model.Plan.ReadOnly] =
      ZIO.succeed(plan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactResponse
  ) extends zio.aws.ssmcontacts.model.GetContactResponse.ReadOnly {
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
    override val alias: ContactAlias =
      zio.aws.ssmcontacts.model.primitives.ContactAlias(impl.alias())
    override val displayName: Optional[ContactName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.ssmcontacts.model.primitives.ContactName(value))
    override val `type`: zio.aws.ssmcontacts.model.ContactType =
      zio.aws.ssmcontacts.model.ContactType.wrap(impl.`type`())
    override val plan: zio.aws.ssmcontacts.model.Plan.ReadOnly =
      zio.aws.ssmcontacts.model.Plan.wrap(impl.plan())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.GetContactResponse
  ): zio.aws.ssmcontacts.model.GetContactResponse.ReadOnly = new Wrapper(impl)
}
