package zio.aws.ssmcontacts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  MaxResults,
  PaginationToken,
  SsmContactsArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListContactChannelsRequest(
    contactId: SsmContactsArn,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest = {
    import ListContactChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest
      .builder()
      .contactId(SsmContactsArn.unwrap(contactId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.ListContactChannelsRequest.ReadOnly =
    zio.aws.ssmcontacts.model.ListContactChannelsRequest.wrap(buildAwsValue())
}
object ListContactChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListContactChannelsRequest =
      zio.aws.ssmcontacts.model.ListContactChannelsRequest(
        contactId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def contactId: SsmContactsArn
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getContactId: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(contactId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest
  ) extends zio.aws.ssmcontacts.model.ListContactChannelsRequest.ReadOnly {
    override val contactId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssmcontacts.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsRequest
  ): zio.aws.ssmcontacts.model.ListContactChannelsRequest.ReadOnly =
    new Wrapper(impl)
}
