package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListContactChannelsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    contactChannels: Iterable[zio.aws.ssmcontacts.model.ContactChannel]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse = {
    import ListContactChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .contactChannels(contactChannels.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.ListContactChannelsResponse.ReadOnly =
    zio.aws.ssmcontacts.model.ListContactChannelsResponse.wrap(buildAwsValue())
}
object ListContactChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListContactChannelsResponse =
      zio.aws.ssmcontacts.model.ListContactChannelsResponse(
        nextToken.map(value => value),
        contactChannels.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def contactChannels: List[zio.aws.ssmcontacts.model.ContactChannel.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getContactChannels: ZIO[Any, Nothing, List[
      zio.aws.ssmcontacts.model.ContactChannel.ReadOnly
    ]] = ZIO.succeed(contactChannels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse
  ) extends zio.aws.ssmcontacts.model.ListContactChannelsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val contactChannels
        : List[zio.aws.ssmcontacts.model.ContactChannel.ReadOnly] = impl
      .contactChannels()
      .asScala
      .map { item =>
        zio.aws.ssmcontacts.model.ContactChannel.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListContactChannelsResponse
  ): zio.aws.ssmcontacts.model.ListContactChannelsResponse.ReadOnly =
    new Wrapper(impl)
}
