package zio.aws.ssmcontacts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  ContactAlias,
  MaxResults,
  PaginationToken
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListContactsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    aliasPrefix: Optional[ContactAlias] = Optional.Absent,
    `type`: Optional[zio.aws.ssmcontacts.model.ContactType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest = {
    import ListContactsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        aliasPrefix.map(value => ContactAlias.unwrap(value): java.lang.String)
      )(_.aliasPrefix)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ListContactsRequest.ReadOnly =
    zio.aws.ssmcontacts.model.ListContactsRequest.wrap(buildAwsValue())
}
object ListContactsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListContactsRequest =
      zio.aws.ssmcontacts.model.ListContactsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        aliasPrefix.map(value => value),
        `type`.map(value => value)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def aliasPrefix: Optional[ContactAlias]
    def `type`: Optional[zio.aws.ssmcontacts.model.ContactType]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAliasPrefix: ZIO[Any, AwsError, ContactAlias] =
      AwsError.unwrapOptionField("aliasPrefix", aliasPrefix)
    def getType: ZIO[Any, AwsError, zio.aws.ssmcontacts.model.ContactType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest
  ) extends zio.aws.ssmcontacts.model.ListContactsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssmcontacts.model.primitives.MaxResults(value))
    override val aliasPrefix: Optional[ContactAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.aliasPrefix())
      .map(value => zio.aws.ssmcontacts.model.primitives.ContactAlias(value))
    override val `type`: Optional[zio.aws.ssmcontacts.model.ContactType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ssmcontacts.model.ContactType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListContactsRequest
  ): zio.aws.ssmcontacts.model.ListContactsRequest.ReadOnly = new Wrapper(impl)
}
