package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListContactsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    contacts: Optional[Iterable[zio.aws.ssmcontacts.model.Contact]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse = {
    import ListContactsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        contacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contacts)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ListContactsResponse.ReadOnly =
    zio.aws.ssmcontacts.model.ListContactsResponse.wrap(buildAwsValue())
}
object ListContactsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListContactsResponse =
      zio.aws.ssmcontacts.model.ListContactsResponse(
        nextToken.map(value => value),
        contacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def contacts: Optional[List[zio.aws.ssmcontacts.model.Contact.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getContacts
        : ZIO[Any, AwsError, List[zio.aws.ssmcontacts.model.Contact.ReadOnly]] =
      AwsError.unwrapOptionField("contacts", contacts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse
  ) extends zio.aws.ssmcontacts.model.ListContactsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val contacts
        : Optional[List[zio.aws.ssmcontacts.model.Contact.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmcontacts.model.Contact.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListContactsResponse
  ): zio.aws.ssmcontacts.model.ListContactsResponse.ReadOnly = new Wrapper(impl)
}
