package zio.aws.ssmcontacts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  IncidentId,
  MaxResults,
  PaginationToken
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListEngagementsRequest(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    incidentId: Optional[IncidentId] = Optional.Absent,
    timeRangeValue: Optional[zio.aws.ssmcontacts.model.TimeRange] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest = {
    import ListEngagementsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        incidentId.map(value => IncidentId.unwrap(value): java.lang.String)
      )(_.incidentId)
      .optionallyWith(timeRangeValue.map(value => value.buildAwsValue()))(
        _.timeRangeValue
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ListEngagementsRequest.ReadOnly =
    zio.aws.ssmcontacts.model.ListEngagementsRequest.wrap(buildAwsValue())
}
object ListEngagementsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListEngagementsRequest =
      zio.aws.ssmcontacts.model.ListEngagementsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value),
        incidentId.map(value => value),
        timeRangeValue.map(value => value.asEditable)
      )
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def incidentId: Optional[IncidentId]
    def timeRangeValue: Optional[zio.aws.ssmcontacts.model.TimeRange.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getIncidentId: ZIO[Any, AwsError, IncidentId] =
      AwsError.unwrapOptionField("incidentId", incidentId)
    def getTimeRangeValue
        : ZIO[Any, AwsError, zio.aws.ssmcontacts.model.TimeRange.ReadOnly] =
      AwsError.unwrapOptionField("timeRangeValue", timeRangeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest
  ) extends zio.aws.ssmcontacts.model.ListEngagementsRequest.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssmcontacts.model.primitives.MaxResults(value))
    override val incidentId: Optional[IncidentId] = zio.aws.core.internal
      .optionalFromNullable(impl.incidentId())
      .map(value => zio.aws.ssmcontacts.model.primitives.IncidentId(value))
    override val timeRangeValue
        : Optional[zio.aws.ssmcontacts.model.TimeRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeRangeValue())
        .map(value => zio.aws.ssmcontacts.model.TimeRange.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsRequest
  ): zio.aws.ssmcontacts.model.ListEngagementsRequest.ReadOnly = new Wrapper(
    impl
  )
}
