package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEngagementsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    engagements: Iterable[zio.aws.ssmcontacts.model.Engagement]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse = {
    import ListEngagementsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .engagements(engagements.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ListEngagementsResponse.ReadOnly =
    zio.aws.ssmcontacts.model.ListEngagementsResponse.wrap(buildAwsValue())
}
object ListEngagementsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListEngagementsResponse =
      zio.aws.ssmcontacts.model.ListEngagementsResponse(
        nextToken.map(value => value),
        engagements.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def engagements: List[zio.aws.ssmcontacts.model.Engagement.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getEngagements: ZIO[Any, Nothing, List[
      zio.aws.ssmcontacts.model.Engagement.ReadOnly
    ]] = ZIO.succeed(engagements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse
  ) extends zio.aws.ssmcontacts.model.ListEngagementsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val engagements
        : List[zio.aws.ssmcontacts.model.Engagement.ReadOnly] = impl
      .engagements()
      .asScala
      .map { item =>
        zio.aws.ssmcontacts.model.Engagement.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListEngagementsResponse
  ): zio.aws.ssmcontacts.model.ListEngagementsResponse.ReadOnly = new Wrapper(
    impl
  )
}
