package zio.aws.ssmcontacts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  MaxResults,
  PaginationToken,
  SsmContactsArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPageReceiptsRequest(
    pageId: SsmContactsArn,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest = {
    import ListPageReceiptsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest
      .builder()
      .pageId(SsmContactsArn.unwrap(pageId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ListPageReceiptsRequest.ReadOnly =
    zio.aws.ssmcontacts.model.ListPageReceiptsRequest.wrap(buildAwsValue())
}
object ListPageReceiptsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListPageReceiptsRequest =
      zio.aws.ssmcontacts.model.ListPageReceiptsRequest(
        pageId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def pageId: SsmContactsArn
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getPageId: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(pageId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest
  ) extends zio.aws.ssmcontacts.model.ListPageReceiptsRequest.ReadOnly {
    override val pageId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.pageId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssmcontacts.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsRequest
  ): zio.aws.ssmcontacts.model.ListPageReceiptsRequest.ReadOnly = new Wrapper(
    impl
  )
}
