package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPageReceiptsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    receipts: Optional[Iterable[zio.aws.ssmcontacts.model.Receipt]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse = {
    import ListPageReceiptsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        receipts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.receipts)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.ListPageReceiptsResponse.ReadOnly =
    zio.aws.ssmcontacts.model.ListPageReceiptsResponse.wrap(buildAwsValue())
}
object ListPageReceiptsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListPageReceiptsResponse =
      zio.aws.ssmcontacts.model.ListPageReceiptsResponse(
        nextToken.map(value => value),
        receipts.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def receipts: Optional[List[zio.aws.ssmcontacts.model.Receipt.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getReceipts
        : ZIO[Any, AwsError, List[zio.aws.ssmcontacts.model.Receipt.ReadOnly]] =
      AwsError.unwrapOptionField("receipts", receipts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse
  ) extends zio.aws.ssmcontacts.model.ListPageReceiptsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val receipts
        : Optional[List[zio.aws.ssmcontacts.model.Receipt.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.receipts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmcontacts.model.Receipt.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListPageReceiptsResponse
  ): zio.aws.ssmcontacts.model.ListPageReceiptsResponse.ReadOnly = new Wrapper(
    impl
  )
}
