package zio.aws.ssmcontacts.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  MaxResults,
  PaginationToken,
  SsmContactsArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPagesByEngagementRequest(
    engagementId: SsmContactsArn,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest = {
    import ListPagesByEngagementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest
      .builder()
      .engagementId(SsmContactsArn.unwrap(engagementId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.ListPagesByEngagementRequest.ReadOnly =
    zio.aws.ssmcontacts.model.ListPagesByEngagementRequest.wrap(buildAwsValue())
}
object ListPagesByEngagementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListPagesByEngagementRequest =
      zio.aws.ssmcontacts.model.ListPagesByEngagementRequest(
        engagementId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def engagementId: SsmContactsArn
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getEngagementId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(engagementId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest
  ) extends zio.aws.ssmcontacts.model.ListPagesByEngagementRequest.ReadOnly {
    override val engagementId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.engagementId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssmcontacts.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementRequest
  ): zio.aws.ssmcontacts.model.ListPagesByEngagementRequest.ReadOnly =
    new Wrapper(impl)
}
