package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPagesByEngagementResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    pages: Iterable[zio.aws.ssmcontacts.model.Page]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse = {
    import ListPagesByEngagementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .pages(pages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.ListPagesByEngagementResponse.ReadOnly =
    zio.aws.ssmcontacts.model.ListPagesByEngagementResponse
      .wrap(buildAwsValue())
}
object ListPagesByEngagementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.ListPagesByEngagementResponse =
      zio.aws.ssmcontacts.model.ListPagesByEngagementResponse(
        nextToken.map(value => value),
        pages.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[PaginationToken]
    def pages: List[zio.aws.ssmcontacts.model.Page.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPages
        : ZIO[Any, Nothing, List[zio.aws.ssmcontacts.model.Page.ReadOnly]] =
      ZIO.succeed(pages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse
  ) extends zio.aws.ssmcontacts.model.ListPagesByEngagementResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmcontacts.model.primitives.PaginationToken(value))
    override val pages: List[zio.aws.ssmcontacts.model.Page.ReadOnly] = impl
      .pages()
      .asScala
      .map { item =>
        zio.aws.ssmcontacts.model.Page.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.ListPagesByEngagementResponse
  ): zio.aws.ssmcontacts.model.ListPagesByEngagementResponse.ReadOnly =
    new Wrapper(impl)
}
