package zio.aws.ssmcontacts.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  DateTime,
  IncidentId,
  Sender,
  SsmContactsArn
}
import scala.jdk.CollectionConverters._
final case class Page(
    pageArn: SsmContactsArn,
    engagementArn: SsmContactsArn,
    contactArn: SsmContactsArn,
    sender: Sender,
    incidentId: Optional[IncidentId] = Optional.Absent,
    sentTime: Optional[DateTime] = Optional.Absent,
    deliveryTime: Optional[DateTime] = Optional.Absent,
    readTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.Page = {
    import Page.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.Page
      .builder()
      .pageArn(SsmContactsArn.unwrap(pageArn): java.lang.String)
      .engagementArn(SsmContactsArn.unwrap(engagementArn): java.lang.String)
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .sender(Sender.unwrap(sender): java.lang.String)
      .optionallyWith(
        incidentId.map(value => IncidentId.unwrap(value): java.lang.String)
      )(_.incidentId)
      .optionallyWith(sentTime.map(value => DateTime.unwrap(value): Instant))(
        _.sentTime
      )
      .optionallyWith(
        deliveryTime.map(value => DateTime.unwrap(value): Instant)
      )(_.deliveryTime)
      .optionallyWith(readTime.map(value => DateTime.unwrap(value): Instant))(
        _.readTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.Page.ReadOnly =
    zio.aws.ssmcontacts.model.Page.wrap(buildAwsValue())
}
object Page {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmcontacts.model.Page] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.Page =
      zio.aws.ssmcontacts.model.Page(
        pageArn,
        engagementArn,
        contactArn,
        sender,
        incidentId.map(value => value),
        sentTime.map(value => value),
        deliveryTime.map(value => value),
        readTime.map(value => value)
      )
    def pageArn: SsmContactsArn
    def engagementArn: SsmContactsArn
    def contactArn: SsmContactsArn
    def sender: Sender
    def incidentId: Optional[IncidentId]
    def sentTime: Optional[DateTime]
    def deliveryTime: Optional[DateTime]
    def readTime: Optional[DateTime]
    def getPageArn: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(pageArn)
    def getEngagementArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(engagementArn)
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
    def getSender: ZIO[Any, Nothing, Sender] = ZIO.succeed(sender)
    def getIncidentId: ZIO[Any, AwsError, IncidentId] =
      AwsError.unwrapOptionField("incidentId", incidentId)
    def getSentTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("sentTime", sentTime)
    def getDeliveryTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("deliveryTime", deliveryTime)
    def getReadTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("readTime", readTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Page
  ) extends zio.aws.ssmcontacts.model.Page.ReadOnly {
    override val pageArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.pageArn())
    override val engagementArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.engagementArn())
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
    override val sender: Sender =
      zio.aws.ssmcontacts.model.primitives.Sender(impl.sender())
    override val incidentId: Optional[IncidentId] = zio.aws.core.internal
      .optionalFromNullable(impl.incidentId())
      .map(value => zio.aws.ssmcontacts.model.primitives.IncidentId(value))
    override val sentTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.sentTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
    override val deliveryTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
    override val readTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.readTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Page
  ): zio.aws.ssmcontacts.model.Page.ReadOnly = new Wrapper(impl)
}
