package zio.aws.ssmcontacts.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Plan(stages: Iterable[zio.aws.ssmcontacts.model.Stage]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.Plan = {
    import Plan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.Plan
      .builder()
      .stages(stages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.Plan.ReadOnly =
    zio.aws.ssmcontacts.model.Plan.wrap(buildAwsValue())
}
object Plan {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmcontacts.model.Plan] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.Plan =
      zio.aws.ssmcontacts.model.Plan(stages.map { item =>
        item.asEditable
      })
    def stages: List[zio.aws.ssmcontacts.model.Stage.ReadOnly]
    def getStages
        : ZIO[Any, Nothing, List[zio.aws.ssmcontacts.model.Stage.ReadOnly]] =
      ZIO.succeed(stages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Plan
  ) extends zio.aws.ssmcontacts.model.Plan.ReadOnly {
    override val stages: List[zio.aws.ssmcontacts.model.Stage.ReadOnly] = impl
      .stages()
      .asScala
      .map { item =>
        zio.aws.ssmcontacts.model.Stage.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Plan
  ): zio.aws.ssmcontacts.model.Plan.ReadOnly = new Wrapper(impl)
}
