package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{Policy, SsmContactsArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutContactPolicyRequest(
    contactArn: SsmContactsArn,
    policy: Policy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.PutContactPolicyRequest = {
    import PutContactPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.PutContactPolicyRequest
      .builder()
      .contactArn(SsmContactsArn.unwrap(contactArn): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.PutContactPolicyRequest.ReadOnly =
    zio.aws.ssmcontacts.model.PutContactPolicyRequest.wrap(buildAwsValue())
}
object PutContactPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.PutContactPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.PutContactPolicyRequest =
      zio.aws.ssmcontacts.model.PutContactPolicyRequest(contactArn, policy)
    def contactArn: SsmContactsArn
    def policy: Policy
    def getContactArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactArn)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.PutContactPolicyRequest
  ) extends zio.aws.ssmcontacts.model.PutContactPolicyRequest.ReadOnly {
    override val contactArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactArn())
    override val policy: Policy =
      zio.aws.ssmcontacts.model.primitives.Policy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.PutContactPolicyRequest
  ): zio.aws.ssmcontacts.model.PutContactPolicyRequest.ReadOnly = new Wrapper(
    impl
  )
}
