package zio.aws.ssmcontacts.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.{
  DateTime,
  ReceiptInfo,
  SsmContactsArn
}
import scala.jdk.CollectionConverters._
final case class Receipt(
    contactChannelArn: Optional[SsmContactsArn] = Optional.Absent,
    receiptType: zio.aws.ssmcontacts.model.ReceiptType,
    receiptInfo: Optional[ReceiptInfo] = Optional.Absent,
    receiptTime: DateTime
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.Receipt = {
    import Receipt.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.Receipt
      .builder()
      .optionallyWith(
        contactChannelArn.map(value =>
          SsmContactsArn.unwrap(value): java.lang.String
        )
      )(_.contactChannelArn)
      .receiptType(receiptType.unwrap)
      .optionallyWith(
        receiptInfo.map(value => ReceiptInfo.unwrap(value): java.lang.String)
      )(_.receiptInfo)
      .receiptTime(DateTime.unwrap(receiptTime): Instant)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.Receipt.ReadOnly =
    zio.aws.ssmcontacts.model.Receipt.wrap(buildAwsValue())
}
object Receipt {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.Receipt
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.Receipt =
      zio.aws.ssmcontacts.model.Receipt(
        contactChannelArn.map(value => value),
        receiptType,
        receiptInfo.map(value => value),
        receiptTime
      )
    def contactChannelArn: Optional[SsmContactsArn]
    def receiptType: zio.aws.ssmcontacts.model.ReceiptType
    def receiptInfo: Optional[ReceiptInfo]
    def receiptTime: DateTime
    def getContactChannelArn: ZIO[Any, AwsError, SsmContactsArn] =
      AwsError.unwrapOptionField("contactChannelArn", contactChannelArn)
    def getReceiptType
        : ZIO[Any, Nothing, zio.aws.ssmcontacts.model.ReceiptType] =
      ZIO.succeed(receiptType)
    def getReceiptInfo: ZIO[Any, AwsError, ReceiptInfo] =
      AwsError.unwrapOptionField("receiptInfo", receiptInfo)
    def getReceiptTime: ZIO[Any, Nothing, DateTime] = ZIO.succeed(receiptTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Receipt
  ) extends zio.aws.ssmcontacts.model.Receipt.ReadOnly {
    override val contactChannelArn: Optional[SsmContactsArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactChannelArn())
        .map(value =>
          zio.aws.ssmcontacts.model.primitives.SsmContactsArn(value)
        )
    override val receiptType: zio.aws.ssmcontacts.model.ReceiptType =
      zio.aws.ssmcontacts.model.ReceiptType.wrap(impl.receiptType())
    override val receiptInfo: Optional[ReceiptInfo] = zio.aws.core.internal
      .optionalFromNullable(impl.receiptInfo())
      .map(value => zio.aws.ssmcontacts.model.primitives.ReceiptInfo(value))
    override val receiptTime: DateTime =
      zio.aws.ssmcontacts.model.primitives.DateTime(impl.receiptTime())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Receipt
  ): zio.aws.ssmcontacts.model.Receipt.ReadOnly = new Wrapper(impl)
}
