package zio.aws.ssmcontacts.model
import scala.jdk.CollectionConverters._
sealed trait ReceiptType {
  def unwrap: software.amazon.awssdk.services.ssmcontacts.model.ReceiptType
}
object ReceiptType {
  def wrap(
      value: software.amazon.awssdk.services.ssmcontacts.model.ReceiptType
  ): zio.aws.ssmcontacts.model.ReceiptType = value match {
    case software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.DELIVERED =>
      val r = DELIVERED
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.READ =>
      val r = READ
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.SENT =>
      val r = SENT
      r
    case software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.STOP =>
      val r = STOP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssmcontacts.model.ReceiptType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ReceiptType =
      software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.UNKNOWN_TO_SDK_VERSION
  }
  case object DELIVERED extends zio.aws.ssmcontacts.model.ReceiptType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ReceiptType =
      software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.DELIVERED
  }
  case object ERROR extends zio.aws.ssmcontacts.model.ReceiptType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ReceiptType =
      software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.ERROR
  }
  case object READ extends zio.aws.ssmcontacts.model.ReceiptType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ReceiptType =
      software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.READ
  }
  case object SENT extends zio.aws.ssmcontacts.model.ReceiptType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ReceiptType =
      software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.SENT
  }
  case object STOP extends zio.aws.ssmcontacts.model.ReceiptType {
    override def unwrap
        : software.amazon.awssdk.services.ssmcontacts.model.ReceiptType =
      software.amazon.awssdk.services.ssmcontacts.model.ReceiptType.STOP
  }
}
