package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SendActivationCodeRequest(contactChannelId: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.SendActivationCodeRequest = {
    import SendActivationCodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.SendActivationCodeRequest
      .builder()
      .contactChannelId(
        SsmContactsArn.unwrap(contactChannelId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.SendActivationCodeRequest.ReadOnly =
    zio.aws.ssmcontacts.model.SendActivationCodeRequest.wrap(buildAwsValue())
}
object SendActivationCodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.SendActivationCodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.SendActivationCodeRequest =
      zio.aws.ssmcontacts.model.SendActivationCodeRequest(contactChannelId)
    def contactChannelId: SsmContactsArn
    def getContactChannelId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.SendActivationCodeRequest
  ) extends zio.aws.ssmcontacts.model.SendActivationCodeRequest.ReadOnly {
    override val contactChannelId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.SendActivationCodeRequest
  ): zio.aws.ssmcontacts.model.SendActivationCodeRequest.ReadOnly = new Wrapper(
    impl
  )
}
