package zio.aws.ssmcontacts.model
import java.lang.Integer
import zio.aws.ssmcontacts.model.primitives.StageDurationInMins
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Stage(
    durationInMinutes: StageDurationInMins,
    targets: Iterable[zio.aws.ssmcontacts.model.Target]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.Stage = {
    import Stage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.Stage
      .builder()
      .durationInMinutes(StageDurationInMins.unwrap(durationInMinutes): Integer)
      .targets(targets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.Stage.ReadOnly =
    zio.aws.ssmcontacts.model.Stage.wrap(buildAwsValue())
}
object Stage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmcontacts.model.Stage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.Stage =
      zio.aws.ssmcontacts.model.Stage(
        durationInMinutes,
        targets.map { item =>
          item.asEditable
        }
      )
    def durationInMinutes: StageDurationInMins
    def targets: List[zio.aws.ssmcontacts.model.Target.ReadOnly]
    def getDurationInMinutes: ZIO[Any, Nothing, StageDurationInMins] =
      ZIO.succeed(durationInMinutes)
    def getTargets
        : ZIO[Any, Nothing, List[zio.aws.ssmcontacts.model.Target.ReadOnly]] =
      ZIO.succeed(targets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Stage
  ) extends zio.aws.ssmcontacts.model.Stage.ReadOnly {
    override val durationInMinutes: StageDurationInMins =
      zio.aws.ssmcontacts.model.primitives
        .StageDurationInMins(impl.durationInMinutes())
    override val targets: List[zio.aws.ssmcontacts.model.Target.ReadOnly] = impl
      .targets()
      .asScala
      .map { item =>
        zio.aws.ssmcontacts.model.Target.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Stage
  ): zio.aws.ssmcontacts.model.Stage.ReadOnly = new Wrapper(impl)
}
