package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{
  PublicSubject,
  SsmContactsArn,
  IdempotencyToken,
  PublicContent,
  Subject,
  Sender,
  IncidentId,
  Content
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartEngagementRequest(
    contactId: SsmContactsArn,
    sender: Sender,
    subject: Subject,
    content: Content,
    publicSubject: Optional[PublicSubject] = Optional.Absent,
    publicContent: Optional[PublicContent] = Optional.Absent,
    incidentId: Optional[IncidentId] = Optional.Absent,
    idempotencyToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.StartEngagementRequest = {
    import StartEngagementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.StartEngagementRequest
      .builder()
      .contactId(SsmContactsArn.unwrap(contactId): java.lang.String)
      .sender(Sender.unwrap(sender): java.lang.String)
      .subject(Subject.unwrap(subject): java.lang.String)
      .content(Content.unwrap(content): java.lang.String)
      .optionallyWith(
        publicSubject.map(value =>
          PublicSubject.unwrap(value): java.lang.String
        )
      )(_.publicSubject)
      .optionallyWith(
        publicContent.map(value =>
          PublicContent.unwrap(value): java.lang.String
        )
      )(_.publicContent)
      .optionallyWith(
        incidentId.map(value => IncidentId.unwrap(value): java.lang.String)
      )(_.incidentId)
      .optionallyWith(
        idempotencyToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.idempotencyToken)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.StartEngagementRequest.ReadOnly =
    zio.aws.ssmcontacts.model.StartEngagementRequest.wrap(buildAwsValue())
}
object StartEngagementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.StartEngagementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.StartEngagementRequest =
      zio.aws.ssmcontacts.model.StartEngagementRequest(
        contactId,
        sender,
        subject,
        content,
        publicSubject.map(value => value),
        publicContent.map(value => value),
        incidentId.map(value => value),
        idempotencyToken.map(value => value)
      )
    def contactId: SsmContactsArn
    def sender: Sender
    def subject: Subject
    def content: Content
    def publicSubject: Optional[PublicSubject]
    def publicContent: Optional[PublicContent]
    def incidentId: Optional[IncidentId]
    def idempotencyToken: Optional[IdempotencyToken]
    def getContactId: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(contactId)
    def getSender: ZIO[Any, Nothing, Sender] = ZIO.succeed(sender)
    def getSubject: ZIO[Any, Nothing, Subject] = ZIO.succeed(subject)
    def getContent: ZIO[Any, Nothing, Content] = ZIO.succeed(content)
    def getPublicSubject: ZIO[Any, AwsError, PublicSubject] =
      AwsError.unwrapOptionField("publicSubject", publicSubject)
    def getPublicContent: ZIO[Any, AwsError, PublicContent] =
      AwsError.unwrapOptionField("publicContent", publicContent)
    def getIncidentId: ZIO[Any, AwsError, IncidentId] =
      AwsError.unwrapOptionField("incidentId", incidentId)
    def getIdempotencyToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("idempotencyToken", idempotencyToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.StartEngagementRequest
  ) extends zio.aws.ssmcontacts.model.StartEngagementRequest.ReadOnly {
    override val contactId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactId())
    override val sender: Sender =
      zio.aws.ssmcontacts.model.primitives.Sender(impl.sender())
    override val subject: Subject =
      zio.aws.ssmcontacts.model.primitives.Subject(impl.subject())
    override val content: Content =
      zio.aws.ssmcontacts.model.primitives.Content(impl.content())
    override val publicSubject: Optional[PublicSubject] = zio.aws.core.internal
      .optionalFromNullable(impl.publicSubject())
      .map(value => zio.aws.ssmcontacts.model.primitives.PublicSubject(value))
    override val publicContent: Optional[PublicContent] = zio.aws.core.internal
      .optionalFromNullable(impl.publicContent())
      .map(value => zio.aws.ssmcontacts.model.primitives.PublicContent(value))
    override val incidentId: Optional[IncidentId] = zio.aws.core.internal
      .optionalFromNullable(impl.incidentId())
      .map(value => zio.aws.ssmcontacts.model.primitives.IncidentId(value))
    override val idempotencyToken: Optional[IdempotencyToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idempotencyToken())
        .map(value =>
          zio.aws.ssmcontacts.model.primitives.IdempotencyToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.StartEngagementRequest
  ): zio.aws.ssmcontacts.model.StartEngagementRequest.ReadOnly = new Wrapper(
    impl
  )
}
