package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.SsmContactsArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class StartEngagementResponse(engagementArn: SsmContactsArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.StartEngagementResponse = {
    import StartEngagementResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.StartEngagementResponse
      .builder()
      .engagementArn(SsmContactsArn.unwrap(engagementArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.StartEngagementResponse.ReadOnly =
    zio.aws.ssmcontacts.model.StartEngagementResponse.wrap(buildAwsValue())
}
object StartEngagementResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.StartEngagementResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.StartEngagementResponse =
      zio.aws.ssmcontacts.model.StartEngagementResponse(engagementArn)
    def engagementArn: SsmContactsArn
    def getEngagementArn: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(engagementArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.StartEngagementResponse
  ) extends zio.aws.ssmcontacts.model.StartEngagementResponse.ReadOnly {
    override val engagementArn: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.engagementArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.StartEngagementResponse
  ): zio.aws.ssmcontacts.model.StartEngagementResponse.ReadOnly = new Wrapper(
    impl
  )
}
