package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{StopReason, SsmContactsArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StopEngagementRequest(
    engagementId: SsmContactsArn,
    reason: Optional[StopReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.StopEngagementRequest = {
    import StopEngagementRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.StopEngagementRequest
      .builder()
      .engagementId(SsmContactsArn.unwrap(engagementId): java.lang.String)
      .optionallyWith(
        reason.map(value => StopReason.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.StopEngagementRequest.ReadOnly =
    zio.aws.ssmcontacts.model.StopEngagementRequest.wrap(buildAwsValue())
}
object StopEngagementRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.StopEngagementRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.StopEngagementRequest =
      zio.aws.ssmcontacts.model
        .StopEngagementRequest(engagementId, reason.map(value => value))
    def engagementId: SsmContactsArn
    def reason: Optional[StopReason]
    def getEngagementId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(engagementId)
    def getReason: ZIO[Any, AwsError, StopReason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.StopEngagementRequest
  ) extends zio.aws.ssmcontacts.model.StopEngagementRequest.ReadOnly {
    override val engagementId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.engagementId())
    override val reason: Optional[StopReason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.ssmcontacts.model.primitives.StopReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.StopEngagementRequest
  ): zio.aws.ssmcontacts.model.StopEngagementRequest.ReadOnly = new Wrapper(
    impl
  )
}
