package zio.aws.ssmcontacts.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Target(
    channelTargetInfo: Optional[zio.aws.ssmcontacts.model.ChannelTargetInfo] =
      Optional.Absent,
    contactTargetInfo: Optional[zio.aws.ssmcontacts.model.ContactTargetInfo] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.Target = {
    import Target.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.Target
      .builder()
      .optionallyWith(channelTargetInfo.map(value => value.buildAwsValue()))(
        _.channelTargetInfo
      )
      .optionallyWith(contactTargetInfo.map(value => value.buildAwsValue()))(
        _.contactTargetInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.Target.ReadOnly =
    zio.aws.ssmcontacts.model.Target.wrap(buildAwsValue())
}
object Target {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.Target
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.Target =
      zio.aws.ssmcontacts.model.Target(
        channelTargetInfo.map(value => value.asEditable),
        contactTargetInfo.map(value => value.asEditable)
      )
    def channelTargetInfo
        : Optional[zio.aws.ssmcontacts.model.ChannelTargetInfo.ReadOnly]
    def contactTargetInfo
        : Optional[zio.aws.ssmcontacts.model.ContactTargetInfo.ReadOnly]
    def getChannelTargetInfo: ZIO[
      Any,
      AwsError,
      zio.aws.ssmcontacts.model.ChannelTargetInfo.ReadOnly
    ] = AwsError.unwrapOptionField("channelTargetInfo", channelTargetInfo)
    def getContactTargetInfo: ZIO[
      Any,
      AwsError,
      zio.aws.ssmcontacts.model.ContactTargetInfo.ReadOnly
    ] = AwsError.unwrapOptionField("contactTargetInfo", contactTargetInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Target
  ) extends zio.aws.ssmcontacts.model.Target.ReadOnly {
    override val channelTargetInfo
        : Optional[zio.aws.ssmcontacts.model.ChannelTargetInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channelTargetInfo())
        .map(value => zio.aws.ssmcontacts.model.ChannelTargetInfo.wrap(value))
    override val contactTargetInfo
        : Optional[zio.aws.ssmcontacts.model.ContactTargetInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contactTargetInfo())
        .map(value => zio.aws.ssmcontacts.model.ContactTargetInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.Target
  ): zio.aws.ssmcontacts.model.Target.ReadOnly = new Wrapper(impl)
}
