package zio.aws.ssmcontacts.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmcontacts.model.primitives.DateTime
import scala.jdk.CollectionConverters._
final case class TimeRange(
    startTime: Optional[DateTime] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.TimeRange = {
    import TimeRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.TimeRange
      .builder()
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.TimeRange.ReadOnly =
    zio.aws.ssmcontacts.model.TimeRange.wrap(buildAwsValue())
}
object TimeRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.TimeRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.TimeRange =
      zio.aws.ssmcontacts.model
        .TimeRange(startTime.map(value => value), endTime.map(value => value))
    def startTime: Optional[DateTime]
    def endTime: Optional[DateTime]
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.TimeRange
  ) extends zio.aws.ssmcontacts.model.TimeRange.ReadOnly {
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ssmcontacts.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.TimeRange
  ): zio.aws.ssmcontacts.model.TimeRange.ReadOnly = new Wrapper(impl)
}
