package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{ChannelName, SsmContactsArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateContactChannelRequest(
    contactChannelId: SsmContactsArn,
    name: Optional[ChannelName] = Optional.Absent,
    deliveryAddress: Optional[zio.aws.ssmcontacts.model.ContactChannelAddress] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.UpdateContactChannelRequest = {
    import UpdateContactChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.UpdateContactChannelRequest
      .builder()
      .contactChannelId(
        SsmContactsArn.unwrap(contactChannelId): java.lang.String
      )
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(deliveryAddress.map(value => value.buildAwsValue()))(
        _.deliveryAddress
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssmcontacts.model.UpdateContactChannelRequest.ReadOnly =
    zio.aws.ssmcontacts.model.UpdateContactChannelRequest.wrap(buildAwsValue())
}
object UpdateContactChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.UpdateContactChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.UpdateContactChannelRequest =
      zio.aws.ssmcontacts.model.UpdateContactChannelRequest(
        contactChannelId,
        name.map(value => value),
        deliveryAddress.map(value => value.asEditable)
      )
    def contactChannelId: SsmContactsArn
    def name: Optional[ChannelName]
    def deliveryAddress
        : Optional[zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly]
    def getContactChannelId: ZIO[Any, Nothing, SsmContactsArn] =
      ZIO.succeed(contactChannelId)
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getDeliveryAddress: ZIO[
      Any,
      AwsError,
      zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly
    ] = AwsError.unwrapOptionField("deliveryAddress", deliveryAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.UpdateContactChannelRequest
  ) extends zio.aws.ssmcontacts.model.UpdateContactChannelRequest.ReadOnly {
    override val contactChannelId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives
        .SsmContactsArn(impl.contactChannelId())
    override val name: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssmcontacts.model.primitives.ChannelName(value))
    override val deliveryAddress
        : Optional[zio.aws.ssmcontacts.model.ContactChannelAddress.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliveryAddress())
        .map(value =>
          zio.aws.ssmcontacts.model.ContactChannelAddress.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.UpdateContactChannelRequest
  ): zio.aws.ssmcontacts.model.UpdateContactChannelRequest.ReadOnly =
    new Wrapper(impl)
}
