package zio.aws.ssmcontacts.model
import zio.aws.ssmcontacts.model.primitives.{ContactName, SsmContactsArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateContactRequest(
    contactId: SsmContactsArn,
    displayName: Optional[ContactName] = Optional.Absent,
    plan: Optional[zio.aws.ssmcontacts.model.Plan] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmcontacts.model.UpdateContactRequest = {
    import UpdateContactRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmcontacts.model.UpdateContactRequest
      .builder()
      .contactId(SsmContactsArn.unwrap(contactId): java.lang.String)
      .optionallyWith(
        displayName.map(value => ContactName.unwrap(value): java.lang.String)
      )(_.displayName)
      .optionallyWith(plan.map(value => value.buildAwsValue()))(_.plan)
      .build()
  }
  def asReadOnly: zio.aws.ssmcontacts.model.UpdateContactRequest.ReadOnly =
    zio.aws.ssmcontacts.model.UpdateContactRequest.wrap(buildAwsValue())
}
object UpdateContactRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmcontacts.model.UpdateContactRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmcontacts.model.UpdateContactRequest =
      zio.aws.ssmcontacts.model.UpdateContactRequest(
        contactId,
        displayName.map(value => value),
        plan.map(value => value.asEditable)
      )
    def contactId: SsmContactsArn
    def displayName: Optional[ContactName]
    def plan: Optional[zio.aws.ssmcontacts.model.Plan.ReadOnly]
    def getContactId: ZIO[Any, Nothing, SsmContactsArn] = ZIO.succeed(contactId)
    def getDisplayName: ZIO[Any, AwsError, ContactName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getPlan: ZIO[Any, AwsError, zio.aws.ssmcontacts.model.Plan.ReadOnly] =
      AwsError.unwrapOptionField("plan", plan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmcontacts.model.UpdateContactRequest
  ) extends zio.aws.ssmcontacts.model.UpdateContactRequest.ReadOnly {
    override val contactId: SsmContactsArn =
      zio.aws.ssmcontacts.model.primitives.SsmContactsArn(impl.contactId())
    override val displayName: Optional[ContactName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value => zio.aws.ssmcontacts.model.primitives.ContactName(value))
    override val plan: Optional[zio.aws.ssmcontacts.model.Plan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.plan())
        .map(value => zio.aws.ssmcontacts.model.Plan.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmcontacts.model.UpdateContactRequest
  ): zio.aws.ssmcontacts.model.UpdateContactRequest.ReadOnly = new Wrapper(impl)
}
