package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{SecretId, DatabaseName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ApplicationCredential(
    databaseName: DatabaseName,
    credentialType: zio.aws.ssmsap.model.CredentialType,
    secretId: SecretId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.ApplicationCredential = {
    import ApplicationCredential.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.ApplicationCredential
      .builder()
      .databaseName(DatabaseName.unwrap(databaseName): java.lang.String)
      .credentialType(credentialType.unwrap)
      .secretId(SecretId.unwrap(secretId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.ApplicationCredential.ReadOnly =
    zio.aws.ssmsap.model.ApplicationCredential.wrap(buildAwsValue())
}
object ApplicationCredential {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.ApplicationCredential
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.ApplicationCredential =
      zio.aws.ssmsap.model
        .ApplicationCredential(databaseName, credentialType, secretId)
    def databaseName: DatabaseName
    def credentialType: zio.aws.ssmsap.model.CredentialType
    def secretId: SecretId
    def getDatabaseName: ZIO[Any, Nothing, DatabaseName] =
      ZIO.succeed(databaseName)
    def getCredentialType
        : ZIO[Any, Nothing, zio.aws.ssmsap.model.CredentialType] =
      ZIO.succeed(credentialType)
    def getSecretId: ZIO[Any, Nothing, SecretId] = ZIO.succeed(secretId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.ApplicationCredential
  ) extends zio.aws.ssmsap.model.ApplicationCredential.ReadOnly {
    override val databaseName: DatabaseName =
      zio.aws.ssmsap.model.primitives.DatabaseName(impl.databaseName())
    override val credentialType: zio.aws.ssmsap.model.CredentialType =
      zio.aws.ssmsap.model.CredentialType.wrap(impl.credentialType())
    override val secretId: SecretId =
      zio.aws.ssmsap.model.primitives.SecretId(impl.secretId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.ApplicationCredential
  ): zio.aws.ssmsap.model.ApplicationCredential.ReadOnly = new Wrapper(impl)
}
