package zio.aws.ssmsap.model
import scala.jdk.CollectionConverters._
sealed trait ApplicationType {
  def unwrap: software.amazon.awssdk.services.ssmsap.model.ApplicationType
}
object ApplicationType {
  def wrap(
      value: software.amazon.awssdk.services.ssmsap.model.ApplicationType
  ): zio.aws.ssmsap.model.ApplicationType = value match {
    case software.amazon.awssdk.services.ssmsap.model.ApplicationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssmsap.model.ApplicationType.HANA =>
      val r = HANA
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssmsap.model.ApplicationType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationType =
      software.amazon.awssdk.services.ssmsap.model.ApplicationType.UNKNOWN_TO_SDK_VERSION
  }
  case object HANA extends zio.aws.ssmsap.model.ApplicationType {
    override def unwrap
        : software.amazon.awssdk.services.ssmsap.model.ApplicationType =
      software.amazon.awssdk.services.ssmsap.model.ApplicationType.HANA
  }
}
