package zio.aws.ssmsap.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteResourcePermissionResponse(
    policy: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionResponse = {
    import DeleteResourcePermissionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionResponse
      .builder()
      .optionallyWith(policy.map(value => value: java.lang.String))(_.policy)
      .build()
  }
  def asReadOnly
      : zio.aws.ssmsap.model.DeleteResourcePermissionResponse.ReadOnly =
    zio.aws.ssmsap.model.DeleteResourcePermissionResponse.wrap(buildAwsValue())
}
object DeleteResourcePermissionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.DeleteResourcePermissionResponse =
      zio.aws.ssmsap.model
        .DeleteResourcePermissionResponse(policy.map(value => value))
    def policy: Optional[String]
    def getPolicy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionResponse
  ) extends zio.aws.ssmsap.model.DeleteResourcePermissionResponse.ReadOnly {
    override val policy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.policy())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.DeleteResourcePermissionResponse
  ): zio.aws.ssmsap.model.DeleteResourcePermissionResponse.ReadOnly =
    new Wrapper(impl)
}
