package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{FilterValue, FilterName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Filter(
    name: FilterName,
    value: FilterValue,
    operator: zio.aws.ssmsap.model.FilterOperator
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssmsap.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.Filter
      .builder()
      .name(FilterName.unwrap(name): java.lang.String)
      .value(FilterValue.unwrap(value): java.lang.String)
      .operator(operator.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.Filter.ReadOnly =
    zio.aws.ssmsap.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssmsap.model.Filter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.Filter =
      zio.aws.ssmsap.model.Filter(name, value, operator)
    def name: FilterName
    def value: FilterValue
    def operator: zio.aws.ssmsap.model.FilterOperator
    def getName: ZIO[Any, Nothing, FilterName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, FilterValue] = ZIO.succeed(value)
    def getOperator: ZIO[Any, Nothing, zio.aws.ssmsap.model.FilterOperator] =
      ZIO.succeed(operator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.Filter
  ) extends zio.aws.ssmsap.model.Filter.ReadOnly {
    override val name: FilterName =
      zio.aws.ssmsap.model.primitives.FilterName(impl.name())
    override val value: FilterValue =
      zio.aws.ssmsap.model.primitives.FilterValue(impl.value())
    override val operator: zio.aws.ssmsap.model.FilterOperator =
      zio.aws.ssmsap.model.FilterOperator.wrap(impl.operator())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.Filter
  ): zio.aws.ssmsap.model.Filter.ReadOnly = new Wrapper(impl)
}
