package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.{
  SsmSapArn,
  DatabaseId,
  ComponentId,
  ApplicationId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetDatabaseRequest(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    componentId: Optional[ComponentId] = Optional.Absent,
    databaseId: Optional[DatabaseId] = Optional.Absent,
    databaseArn: Optional[SsmSapArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.GetDatabaseRequest = {
    import GetDatabaseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.GetDatabaseRequest
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        componentId.map(value => ComponentId.unwrap(value): java.lang.String)
      )(_.componentId)
      .optionallyWith(
        databaseId.map(value => DatabaseId.unwrap(value): java.lang.String)
      )(_.databaseId)
      .optionallyWith(
        databaseArn.map(value => SsmSapArn.unwrap(value): java.lang.String)
      )(_.databaseArn)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.GetDatabaseRequest.ReadOnly =
    zio.aws.ssmsap.model.GetDatabaseRequest.wrap(buildAwsValue())
}
object GetDatabaseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.GetDatabaseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.GetDatabaseRequest =
      zio.aws.ssmsap.model.GetDatabaseRequest(
        applicationId.map(value => value),
        componentId.map(value => value),
        databaseId.map(value => value),
        databaseArn.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def componentId: Optional[ComponentId]
    def databaseId: Optional[DatabaseId]
    def databaseArn: Optional[SsmSapArn]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getComponentId: ZIO[Any, AwsError, ComponentId] =
      AwsError.unwrapOptionField("componentId", componentId)
    def getDatabaseId: ZIO[Any, AwsError, DatabaseId] =
      AwsError.unwrapOptionField("databaseId", databaseId)
    def getDatabaseArn: ZIO[Any, AwsError, SsmSapArn] =
      AwsError.unwrapOptionField("databaseArn", databaseArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.GetDatabaseRequest
  ) extends zio.aws.ssmsap.model.GetDatabaseRequest.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.ssmsap.model.primitives.ApplicationId(value))
    override val componentId: Optional[ComponentId] = zio.aws.core.internal
      .optionalFromNullable(impl.componentId())
      .map(value => zio.aws.ssmsap.model.primitives.ComponentId(value))
    override val databaseId: Optional[DatabaseId] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseId())
      .map(value => zio.aws.ssmsap.model.primitives.DatabaseId(value))
    override val databaseArn: Optional[SsmSapArn] = zio.aws.core.internal
      .optionalFromNullable(impl.databaseArn())
      .map(value => zio.aws.ssmsap.model.primitives.SsmSapArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.GetDatabaseRequest
  ): zio.aws.ssmsap.model.GetDatabaseRequest.ReadOnly = new Wrapper(impl)
}
