package zio.aws.ssmsap.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssmsap.model.primitives.{
  MaxResults,
  NextToken,
  ComponentId,
  ApplicationId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListDatabasesRequest(
    applicationId: Optional[ApplicationId] = Optional.Absent,
    componentId: Optional[ComponentId] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest = {
    import ListDatabasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest
      .builder()
      .optionallyWith(
        applicationId.map(value =>
          ApplicationId.unwrap(value): java.lang.String
        )
      )(_.applicationId)
      .optionallyWith(
        componentId.map(value => ComponentId.unwrap(value): java.lang.String)
      )(_.componentId)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.ListDatabasesRequest.ReadOnly =
    zio.aws.ssmsap.model.ListDatabasesRequest.wrap(buildAwsValue())
}
object ListDatabasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.ListDatabasesRequest =
      zio.aws.ssmsap.model.ListDatabasesRequest(
        applicationId.map(value => value),
        componentId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def applicationId: Optional[ApplicationId]
    def componentId: Optional[ComponentId]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getApplicationId: ZIO[Any, AwsError, ApplicationId] =
      AwsError.unwrapOptionField("applicationId", applicationId)
    def getComponentId: ZIO[Any, AwsError, ComponentId] =
      AwsError.unwrapOptionField("componentId", componentId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest
  ) extends zio.aws.ssmsap.model.ListDatabasesRequest.ReadOnly {
    override val applicationId: Optional[ApplicationId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationId())
      .map(value => zio.aws.ssmsap.model.primitives.ApplicationId(value))
    override val componentId: Optional[ComponentId] = zio.aws.core.internal
      .optionalFromNullable(impl.componentId())
      .map(value => zio.aws.ssmsap.model.primitives.ComponentId(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmsap.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ssmsap.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.ListDatabasesRequest
  ): zio.aws.ssmsap.model.ListDatabasesRequest.ReadOnly = new Wrapper(impl)
}
