package zio.aws.ssmsap.model
import zio.aws.ssmsap.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListOperationsResponse(
    operations: Optional[Iterable[zio.aws.ssmsap.model.Operation]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse = {
    import ListOperationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse
      .builder()
      .optionallyWith(
        operations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.operations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssmsap.model.ListOperationsResponse.ReadOnly =
    zio.aws.ssmsap.model.ListOperationsResponse.wrap(buildAwsValue())
}
object ListOperationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssmsap.model.ListOperationsResponse =
      zio.aws.ssmsap.model.ListOperationsResponse(
        operations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def operations: Optional[List[zio.aws.ssmsap.model.Operation.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getOperations
        : ZIO[Any, AwsError, List[zio.aws.ssmsap.model.Operation.ReadOnly]] =
      AwsError.unwrapOptionField("operations", operations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse
  ) extends zio.aws.ssmsap.model.ListOperationsResponse.ReadOnly {
    override val operations
        : Optional[List[zio.aws.ssmsap.model.Operation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssmsap.model.Operation.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssmsap.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssmsap.model.ListOperationsResponse
  ): zio.aws.ssmsap.model.ListOperationsResponse.ReadOnly = new Wrapper(impl)
}
