package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.Token
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListManagedPoliciesInPermissionSetResponse(
    attachedManagedPolicies: Optional[
      Iterable[zio.aws.ssoadmin.model.AttachedManagedPolicy]
    ] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse = {
    import ListManagedPoliciesInPermissionSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
      .builder()
      .optionallyWith(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachedManagedPolicies)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly =
    zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
      .wrap(buildAwsValue())
}
object ListManagedPoliciesInPermissionSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse =
      zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse(
        attachedManagedPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def attachedManagedPolicies
        : Optional[List[zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly]]
    def nextToken: Optional[Token]
    def getAttachedManagedPolicies: ZIO[Any, AwsError, List[
      zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "attachedManagedPolicies",
      attachedManagedPolicies
    )
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
  ) extends zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly {
    override val attachedManagedPolicies: Optional[
      List[zio.aws.ssoadmin.model.AttachedManagedPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedManagedPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssoadmin.model.AttachedManagedPolicy.wrap(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssoadmin.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
  ): zio.aws.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse.ReadOnly =
    new Wrapper(impl)
}
