package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class OperationStatusFilter(
    status: Optional[zio.aws.ssoadmin.model.StatusValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter = {
    import OperationStatusFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly =
    zio.aws.ssoadmin.model.OperationStatusFilter.wrap(buildAwsValue())
}
object OperationStatusFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.OperationStatusFilter =
      zio.aws.ssoadmin.model.OperationStatusFilter(status.map(value => value))
    def status: Optional[zio.aws.ssoadmin.model.StatusValues]
    def getStatus: ZIO[Any, AwsError, zio.aws.ssoadmin.model.StatusValues] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter
  ) extends zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly {
    override val status: Optional[zio.aws.ssoadmin.model.StatusValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssoadmin.model.StatusValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.OperationStatusFilter
  ): zio.aws.ssoadmin.model.OperationStatusFilter.ReadOnly = new Wrapper(impl)
}
