package zio.aws.ssoadmin.model
import scala.jdk.CollectionConverters.*
sealed trait ProvisionTargetType {
  def unwrap: software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType
}
object ProvisionTargetType {
  def wrap(
      value: software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType
  ): zio.aws.ssoadmin.model.ProvisionTargetType = value match {
    case software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType.AWS_ACCOUNT =>
      val r = AWS_ACCOUNT
      r
    case software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType.ALL_PROVISIONED_ACCOUNTS =>
      val r = ALL_PROVISIONED_ACCOUNTS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssoadmin.model.ProvisionTargetType {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType =
      software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_ACCOUNT extends zio.aws.ssoadmin.model.ProvisionTargetType {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType =
      software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType.AWS_ACCOUNT
  }
  case object ALL_PROVISIONED_ACCOUNTS
      extends zio.aws.ssoadmin.model.ProvisionTargetType {
    override def unwrap
        : software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType =
      software.amazon.awssdk.services.ssoadmin.model.ProvisionTargetType.ALL_PROVISIONED_ACCOUNTS
  }
}
