package zio.aws.ssoadmin.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.ssoadmin.model.primitives.{ManagedPolicyPath, ManagedPolicyName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomerManagedPolicyReference(
    name: ManagedPolicyName,
    path: Optional[ManagedPolicyPath] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssoadmin.model.CustomerManagedPolicyReference = {
    import CustomerManagedPolicyReference.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssoadmin.model.CustomerManagedPolicyReference
      .builder()
      .name(ManagedPolicyName.unwrap(name): java.lang.String)
      .optionallyWith(
        path.map(value => ManagedPolicyPath.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly
      : zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly =
    zio.aws.ssoadmin.model.CustomerManagedPolicyReference.wrap(buildAwsValue())
}
object CustomerManagedPolicyReference {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssoadmin.model.CustomerManagedPolicyReference
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssoadmin.model.CustomerManagedPolicyReference =
      zio.aws.ssoadmin.model
        .CustomerManagedPolicyReference(name, path.map(value => value))
    def name: ManagedPolicyName
    def path: Optional[ManagedPolicyPath]
    def getName: ZIO[Any, Nothing, ManagedPolicyName] = ZIO.succeed(name)
    def getPath: ZIO[Any, AwsError, ManagedPolicyPath] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssoadmin.model.CustomerManagedPolicyReference
  ) extends zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly {
    override val name: ManagedPolicyName =
      zio.aws.ssoadmin.model.primitives.ManagedPolicyName(impl.name())
    override val path: Optional[ManagedPolicyPath] = zio.aws.core.internal
      .optionalFromNullable(impl.path())
      .map(value => zio.aws.ssoadmin.model.primitives.ManagedPolicyPath(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssoadmin.model.CustomerManagedPolicyReference
  ): zio.aws.ssoadmin.model.CustomerManagedPolicyReference.ReadOnly =
    new Wrapper(impl)
}
